/*	Link attachment */

var attachLinks = function() {
	$(".menu a, area").click(function() {
		var href = $(this).attr("href");
		history.pushState({}, '', href);
		$.ajax({
			url: href,
			success: function(text){
				$(".posts").html($(text).closest(".posts").children());
				document.title = $(text).filter('title').text();
				ga('send','pageview',document.location.pathname);
				updateSchedule();
			}
		});
		return false;
	});
}

//	Configure actions for when visitor uses back button
window.onpopstate = function(event) {
	var href = document.location;
	$.ajax({
		url: href,
		success: function(text){
			$(".posts").html($(text).closest(".posts").children());
			document.title = $(text).filter('title').text();
			ga('send','pageview',document.location.pathname);
		}
	});
}

/* Now Playing */

var LOGO_URL = THEME_URL + "/img/logo3.png";
var LOGO_SPIN_URL = THEME_URL + "/img/logo3-rotating.gif";
var UPDATE_NOWPLAYING_INTERVAL = 10000;
var currentShow;

var updateNowPlaying = function() {
	$.get("/test/np.php", function(data) {
		if (data != currentShow && currentShow != "") {
			currentShow = data;
			updateBackgroundImage(data);
		}
		$(".jp-title").html("Now Playing: " + data);
	});
	setTimeout(updateNowPlaying, UPDATE_NOWPLAYING_INTERVAL);
}

var updateBackgroundImage = function(data) {
	var matched = false;
	finalimage = null;
	if (data.toLowerCase().indexOf("archive") > -1) {
		$('.djimg').fadeTo("slow", 0.0, function(){
			$('.djimg').css("background-image","url('" + THEME_URL + "/img/djs/archive.jpg" + "')");
			$('.djimg').fadeTo("slow", 1.0);
		});
	} else {
		for (i in DJ_IMAGES) {
			if(!finalimage && DJ_IMAGES[i]!= "." && DJ_IMAGES[i] != "archive.jpg"  && DJ_IMAGES[i] != ".." && data.toLowerCase().indexOf(DJ_IMAGES[i].split(".")[0]) > -1){
				finalimage = i;
				$('.djimg').fadeTo("slow", 0.0, function(){
					$('.djimg').css("background-image","url('" + THEME_URL + "/img/djs/" + DJ_IMAGES[finalimage] + "')");
					$('.djimg').fadeTo("slow", 1.0);
				});
				matched = true;
			}
		}
	}
	if(!matched){
		$('.djimg').fadeTo("slow", 0.0);
	}
}

/* JPlayer */

var START_LISTENING_TIMEOUT = 600000;
var isListening;

var startListening = function(start) {
	if (start) {
		isListening = true;
		ga('set', 'metric1', 0);
		ga('send','event','stream','play',$(".jp-title").text().substr(13));
	}
	else {
		ga('set', 'metric1', 600);
		ga('send','event','stream','listening',$(".jp-title").text().substr(13));
	}
	setTimeout(startListening, START_LISTENING_TIMEOUT);
}

var stopListening = function() {
	isListening = false;
}

var setUpPlayer = function() {
	var stream = {
		title: "&nbsp;",
		mp3: "http://music.clouwdnine.com:8080/stream"
	},
	ready = false;

	$(".jplayer").jPlayer( {
		ready: function (event) {
			ready = true;
			$(this).jPlayer("setMedia", stream);
		},
		play: function() {
			ga('set', 'dimension1', $(".jp-title").text().substr(13));
			ga('set', 'dimension2', $(".jp-title").text().indexOf("[LIVE]") != -1);
			ga('send','event','stream','play',$(".jp-title").text().substr(13));
			startListening(true);
		},
		pause: function() {
			$(this).jPlayer("clearMedia");
			ga('set', 'dimension1', $(".jp-title").text().substr(13));
			ga('set', 'dimension2', $(".jp-title").text().indexOf("[LIVE]") != -1);
			ga('send','event','stream','pause',$(".jp-title").text().substr(13));
			stopListening();
		},
		error: function(event) {
			if(ready && event.jPlayer.error.type === $.jPlayer.error.URL_NOT_SET) {
				// Setup the media stream again and play it.
				$(this).jPlayer("setMedia", stream).jPlayer("play");
			}
		},
		cssSelectorAncestor: ".jp-container",
		swfPath: THEME_URL + "/js",
		supplied: "mp3",
		preload: "none",
		wmode: "window",
		verticalVolume: true,
		keyEnabled: true
	});
}

/* Timer */

function c9timer() {
	var d = new Date();
  var offset = d.getTimezoneOffset() + 60;
	//var offset = d.getTimezoneOffset();
	var u = new Date();
	u.setMinutes(u.getMinutes() + offset)
	if(document.getElementById("local-time")) {
		document.getElementById("local-time").innerHTML = d.toLocaleTimeString();
		document.getElementById("c9-time").innerHTML = u.toLocaleTimeString();
	}
	setTimeout(c9timer, 1000);
}

/* Page initiation */

$(document).ready(function() {
	setUpPlayer();
	attachLinks();
	updateNowPlaying();
	c9timer();
});
