var START_LISTENING_TIMEOUT = 600000;
var isListening;

var startListening = function(start) {
	if (start) {
		isListening = true;
		ga('set', 'metric1', 0);
		ga('send','event','stream','play',$(".jp-title").text().substr(13));
	}
	else {
		ga('set', 'metric1', 600);
		ga('send','event','stream','listening',$(".jp-title").text().substr(13));
	}
	setTimeout(startListening, START_LISTENING_TIMEOUT);
}

var stopListening = function() {
	isListening = false;
}

var setUpPlayer = function() {
	var stream = {
		title: "&nbsp;",
		mp3: "http://www.clouwdnine.com/test/stream.php"
	},
	ready = false;

	$(".jplayer").jPlayer( {
		ready: function (event) {
			ready = true;
			$(this).jPlayer("setMedia", stream);
		},
		play: function() {
			ga('set', 'dimension1', $(".jp-title").text().substr(13));
			ga('set', 'dimension2', $(".jp-title").text().indexOf("[LIVE]") != -1);
			ga('send','event','stream','play',$(".jp-title").text().substr(13));
			startListening(true);
		},
		pause: function() {
			$(this).jPlayer("clearMedia");
			ga('set', 'dimension1', $(".jp-title").text().substr(13));
			ga('set', 'dimension2', $(".jp-title").text().indexOf("[LIVE]") != -1);
			ga('send','event','stream','pause',$(".jp-title").text().substr(13));
			stopListening();
		},
		error: function(event) {
			if(ready && event.jPlayer.error.type === $.jPlayer.error.URL_NOT_SET) {
				// Setup the media stream again and play it.
				$(this).jPlayer("setMedia", stream).jPlayer("play");
			}
		},
		cssSelectorAncestor: ".jp-container",
		swfPath: THEME_DIR + "/js",
		supplied: "mp3",
		preload: "none",
		wmode: "window",
		verticalVolume: true,
		keyEnabled: true
	});
}
